@extends('layouts.app')

@section('title', 'Edit Reply')

@section('content')
<div class="forum-container">
    <div class="forum-breadcrumbs">
        <a href="{{ route('forum.index') }}">Forums</a>
        <span class="separator">/</span>
        <a href="{{ route('forum.board', $board->slug) }}">{{ $board->name }}</a>
        <span class="separator">/</span>
        <a href="{{ route('forum.thread', [$board->slug, $thread->slug]) }}">{{ \Illuminate\Support\Str::limit($thread->title, 30) }}</a>
        <span class="separator">/</span>
        <span class="current">Edit Reply</span>
    </div>

    <div class="forum-edit-post">
        <h1>Edit Reply</h1>
        
        <form action="{{ route('forum.update-post', [$board->slug, $thread->slug, $post->id]) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="form-group">
                <label for="content">Content</label>
                <x-bbcode-editor 
                    name="content"
                    :content="old('content', $post->content)"
                    placeholder="huh?"
                    height="200px"
                />
                @error('content')
                    <div class="error-message">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-actions">
                <a href="{{ route('forum.thread', [$board->slug, $thread->slug]) }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </form>
    </div>
</div>
@endsection